/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.Platform;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.Memory;
import org.python.modules.jffi.NativeMemory;
import org.python.modules.jffi.Util;

public final class HeapMemory
implements Memory {
    protected static final ArrayIO IO = HeapMemory.getArrayIO();
    protected static final int LONG_SIZE = Platform.getPlatform().longSize() / 8;
    protected static final int ADDRESS_SIZE = Platform.getPlatform().addressSize() / 8;
    protected final byte[] buffer;
    protected final int offset;
    protected final int length;

    public HeapMemory(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.offset = n;
        this.length = n2;
    }

    public HeapMemory(int n) {
        this(new byte[n], 0, n);
    }

    private final void checkBounds(long l, long l2) {
        Util.checkBounds(this.arrayLength(), l, l2);
    }

    public final byte[] array() {
        return this.buffer;
    }

    public final int arrayOffset() {
        return this.offset;
    }

    public final int arrayLength() {
        return this.length;
    }

    private static final ArrayIO getArrayIO() {
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            return Platform.getPlatform().addressSize() == 64 ? HeapMemory.newBE64ArrayIO() : HeapMemory.newBE32ArrayIO();
        }
        return Platform.getPlatform().addressSize() == 64 ? HeapMemory.newLE64ArrayIO() : HeapMemory.newLE32ArrayIO();
    }

    private static final ArrayIO newBE64ArrayIO() {
        return new BE64ArrayIO();
    }

    private static final ArrayIO newBE32ArrayIO() {
        return new BE32ArrayIO();
    }

    private static final ArrayIO newLE64ArrayIO() {
        return new LE64ArrayIO();
    }

    private static final ArrayIO newLE32ArrayIO() {
        return new LE32ArrayIO();
    }

    protected final int index(long l) {
        return this.offset + (int)l;
    }

    public final boolean isNull() {
        return false;
    }

    public final boolean isDirect() {
        return false;
    }

    public HeapMemory slice(long l) {
        this.checkBounds(l, 1L);
        return l == 0L ? this : new HeapMemory(this.array(), this.arrayOffset() + (int)l, this.arrayLength() - (int)l);
    }

    public final DirectMemory getMemory(long l) {
        this.checkBounds(l, ADDRESS_SIZE);
        long l2 = this.getAddress(l);
        return l2 != 0L ? new NativeMemory(l2) : null;
    }

    public final void putAddress(long l, Memory memory) {
        this.checkBounds(l, ADDRESS_SIZE);
        this.putAddress(l, ((DirectMemory)memory).getAddress());
    }

    public final byte getByte(long l) {
        this.checkBounds(l, 1L);
        return (byte)(this.buffer[this.index(l)] & 0xFF);
    }

    public final short getShort(long l) {
        this.checkBounds(l, 2L);
        return IO.getInt16(this.buffer, this.index(l));
    }

    public final int getInt(long l) {
        this.checkBounds(l, 4L);
        return IO.getInt32(this.buffer, this.index(l));
    }

    public final long getLong(long l) {
        this.checkBounds(l, 8L);
        return IO.getInt64(this.buffer, this.index(l));
    }

    public final long getNativeLong(long l) {
        return LONG_SIZE == 4 ? (long)this.getInt(l) : this.getLong(l);
    }

    public final float getFloat(long l) {
        this.checkBounds(l, 4L);
        return IO.getFloat32(this.buffer, this.index(l));
    }

    public final double getDouble(long l) {
        this.checkBounds(l, 8L);
        return IO.getFloat64(this.buffer, this.index(l));
    }

    public final long getAddress(long l) {
        this.checkBounds(l, ADDRESS_SIZE);
        return IO.getAddress(this.buffer, this.index(l));
    }

    public final byte[] getZeroTerminatedByteArray(long l) {
        this.checkBounds(l, 1L);
        int n = this.indexOf(l, (byte)0);
        byte[] byArray = new byte[n != -1 ? n : this.length - (int)l];
        System.arraycopy(this.buffer, this.index(l), byArray, 0, byArray.length);
        return byArray;
    }

    public final void putByte(long l, byte by) {
        this.checkBounds(l, 1L);
        this.buffer[this.index((long)l)] = by;
    }

    public final void putShort(long l, short s) {
        this.checkBounds(l, 2L);
        IO.putInt16(this.buffer, this.index(l), s);
    }

    public final void putInt(long l, int n) {
        this.checkBounds(l, 4L);
        IO.putInt32(this.buffer, this.index(l), n);
    }

    public final void putLong(long l, long l2) {
        this.checkBounds(l, 8L);
        IO.putInt64(this.buffer, this.index(l), l2);
    }

    public final void putNativeLong(long l, long l2) {
        if (LONG_SIZE == 4) {
            this.putInt(l, (int)l2);
        } else {
            this.putLong(l, l2);
        }
    }

    public final void putFloat(long l, float f) {
        this.checkBounds(l, 4L);
        IO.putFloat32(this.buffer, this.index(l), f);
    }

    public final void putDouble(long l, double d) {
        this.checkBounds(l, 8L);
        IO.putFloat64(this.buffer, this.index(l), d);
    }

    public final void putAddress(long l, long l2) {
        this.checkBounds(l, ADDRESS_SIZE);
        IO.putAddress(this.buffer, this.index(l), l2);
    }

    public void putZeroTerminatedByteArray(long l, byte[] byArray, int n, int n2) {
        this.checkBounds(l, n2 + 1);
        System.arraycopy(byArray, n, this.buffer, this.index(l), n2);
        this.buffer[n2] = 0;
    }

    public final void get(long l, byte[] byArray, int n, int n2) {
        this.checkBounds(l, n2);
        System.arraycopy(this.buffer, this.index(l), byArray, n, n2);
    }

    public final void put(long l, byte[] byArray, int n, int n2) {
        this.checkBounds(l, n2);
        System.arraycopy(byArray, n, this.buffer, this.index(l), n2);
    }

    public final void get(long l, short[] sArray, int n, int n2) {
        this.checkBounds(l, n2 << 1);
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            sArray[n + i] = IO.getInt16(this.buffer, n3 + (i << 1));
        }
    }

    public final void put(long l, short[] sArray, int n, int n2) {
        this.checkBounds(l, n2 << 1);
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            IO.putInt16(this.buffer, n3 + (i << 1), sArray[n + i]);
        }
    }

    public final void get(long l, int[] nArray, int n, int n2) {
        this.checkBounds(l, n2 << 2);
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = IO.getInt32(this.buffer, n3 + (i << 2));
        }
    }

    public final void put(long l, int[] nArray, int n, int n2) {
        this.checkBounds(l, n2 << 2);
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            IO.putInt32(this.buffer, n3 + (i << 2), nArray[n + i]);
        }
    }

    public final void get(long l, long[] lArray, int n, int n2) {
        this.checkBounds(l, n2 << 3);
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = IO.getInt64(this.buffer, n3 + (i << 3));
        }
    }

    public final void put(long l, long[] lArray, int n, int n2) {
        this.checkBounds(l, n2 << 3);
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            IO.putInt64(this.buffer, n3 + (i << 3), lArray[n + i]);
        }
    }

    public final void get(long l, float[] fArray, int n, int n2) {
        this.checkBounds(l, n2 << 2);
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = IO.getFloat32(this.buffer, n3 + (i << 2));
        }
    }

    public final void put(long l, float[] fArray, int n, int n2) {
        this.checkBounds(l, n2 << 2);
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            IO.putFloat32(this.buffer, n3 + (i << 2), fArray[n + i]);
        }
    }

    public final void get(long l, double[] dArray, int n, int n2) {
        this.checkBounds(l, n2 << 3);
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = IO.getFloat64(this.buffer, n3 + (i << 3));
        }
    }

    public final void put(long l, double[] dArray, int n, int n2) {
        this.checkBounds(l, n2 << 3);
        int n3 = this.index(l);
        for (int i = 0; i < n2; ++i) {
            IO.putFloat64(this.buffer, n3 + (i << 3), dArray[n + i]);
        }
    }

    public final int indexOf(long l, byte by) {
        int n = this.index(l);
        for (int i = 0; i < this.length; ++i) {
            if (this.buffer[n + i] != by) continue;
            return i;
        }
        return -1;
    }

    public final int indexOf(long l, byte by, int n) {
        int n2 = this.index(l);
        for (int i = 0; i < Math.min(this.length, n); ++i) {
            if (this.buffer[n2 + i] != by) continue;
            return i;
        }
        return -1;
    }

    public final void setMemory(long l, long l2, byte by) {
        this.checkBounds(l, l2);
        Arrays.fill(this.buffer, this.index(l), (int)l2, by);
    }

    public final void clear() {
        Arrays.fill(this.buffer, this.offset, this.length, (byte)0);
    }

    protected static abstract class ArrayIO {
        protected ArrayIO() {
        }

        public abstract short getInt16(byte[] var1, int var2);

        public abstract int getInt32(byte[] var1, int var2);

        public abstract long getInt64(byte[] var1, int var2);

        public abstract long getAddress(byte[] var1, int var2);

        public abstract void putInt16(byte[] var1, int var2, int var3);

        public abstract void putInt32(byte[] var1, int var2, int var3);

        public abstract void putInt64(byte[] var1, int var2, long var3);

        public abstract void putAddress(byte[] var1, int var2, long var3);

        public final float getFloat32(byte[] byArray, int n) {
            return Float.intBitsToFloat(this.getInt32(byArray, n));
        }

        public final void putFloat32(byte[] byArray, int n, float f) {
            this.putInt32(byArray, n, Float.floatToRawIntBits(f));
        }

        public final double getFloat64(byte[] byArray, int n) {
            return Double.longBitsToDouble(this.getInt64(byArray, n));
        }

        public final void putFloat64(byte[] byArray, int n, double d) {
            this.putInt64(byArray, n, Double.doubleToRawLongBits(d));
        }
    }

    private static final class BE32ArrayIO
    extends BigEndianArrayIO {
        private BE32ArrayIO() {
        }

        public final long getAddress(byte[] byArray, int n) {
            return (long)this.getInt32(byArray, n) & 0xFFFFFFFFL;
        }

        public final void putAddress(byte[] byArray, int n, long l) {
            this.putInt32(byArray, n, (int)l);
        }
    }

    private static final class BE64ArrayIO
    extends BigEndianArrayIO {
        private BE64ArrayIO() {
        }

        public final long getAddress(byte[] byArray, int n) {
            return this.getInt64(byArray, n);
        }

        public final void putAddress(byte[] byArray, int n, long l) {
            this.putInt64(byArray, n, l);
        }
    }

    private static abstract class BigEndianArrayIO
    extends ArrayIO {
        private BigEndianArrayIO() {
        }

        public short getInt16(byte[] byArray, int n) {
            return (short)((byArray[n + 0] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
        }

        public int getInt32(byte[] byArray, int n) {
            return (byArray[n + 0] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 3] & 0xFF) << 0;
        }

        public long getInt64(byte[] byArray, int n) {
            return ((long)byArray[n + 0] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | ((long)byArray[n + 7] & 0xFFL) << 0;
        }

        public final void putInt16(byte[] byArray, int n, int n2) {
            byArray[n + 0] = (byte)(n2 >> 8);
            byArray[n + 1] = (byte)(n2 >> 0);
        }

        public final void putInt32(byte[] byArray, int n, int n2) {
            byArray[n + 0] = (byte)(n2 >> 24);
            byArray[n + 1] = (byte)(n2 >> 16);
            byArray[n + 2] = (byte)(n2 >> 8);
            byArray[n + 3] = (byte)(n2 >> 0);
        }

        public final void putInt64(byte[] byArray, int n, long l) {
            byArray[n + 0] = (byte)(l >> 56);
            byArray[n + 1] = (byte)(l >> 48);
            byArray[n + 2] = (byte)(l >> 40);
            byArray[n + 3] = (byte)(l >> 32);
            byArray[n + 4] = (byte)(l >> 24);
            byArray[n + 5] = (byte)(l >> 16);
            byArray[n + 6] = (byte)(l >> 8);
            byArray[n + 7] = (byte)(l >> 0);
        }
    }

    private static final class LE32ArrayIO
    extends LittleEndianArrayIO {
        private LE32ArrayIO() {
        }

        public final long getAddress(byte[] byArray, int n) {
            return (long)this.getInt32(byArray, n) & 0xFFFFFFFFL;
        }

        public final void putAddress(byte[] byArray, int n, long l) {
            this.putInt32(byArray, n, (int)l);
        }
    }

    private static final class LE64ArrayIO
    extends LittleEndianArrayIO {
        private LE64ArrayIO() {
        }

        public final long getAddress(byte[] byArray, int n) {
            return this.getInt64(byArray, n);
        }

        public final void putAddress(byte[] byArray, int n, long l) {
            this.putInt64(byArray, n, l);
        }
    }

    private static abstract class LittleEndianArrayIO
    extends ArrayIO {
        private LittleEndianArrayIO() {
        }

        public final short getInt16(byte[] byArray, int n) {
            return (short)(byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8);
        }

        public final int getInt32(byte[] byArray, int n) {
            return (byArray[n + 0] & 0xFF) << 0 | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        }

        public final long getInt64(byte[] byArray, int n) {
            return ((long)byArray[n + 0] & 0xFFL) << 0 | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
        }

        public final void putInt16(byte[] byArray, int n, int n2) {
            byArray[n + 0] = (byte)(n2 >> 0);
            byArray[n + 1] = (byte)(n2 >> 8);
        }

        public final void putInt32(byte[] byArray, int n, int n2) {
            byArray[n + 0] = (byte)(n2 >> 0);
            byArray[n + 1] = (byte)(n2 >> 8);
            byArray[n + 2] = (byte)(n2 >> 16);
            byArray[n + 3] = (byte)(n2 >> 24);
        }

        public final void putInt64(byte[] byArray, int n, long l) {
            byArray[n + 0] = (byte)(l >> 0);
            byArray[n + 1] = (byte)(l >> 8);
            byArray[n + 2] = (byte)(l >> 16);
            byArray[n + 3] = (byte)(l >> 24);
            byArray[n + 4] = (byte)(l >> 32);
            byArray[n + 5] = (byte)(l >> 40);
            byArray[n + 6] = (byte)(l >> 48);
            byArray[n + 7] = (byte)(l >> 56);
        }
    }
}

